/*
 * Programa para el ArduinoNano ver 2 que utiliza dos displays SDD1306 OLED de 128x64 pix
 * Ambos displays tienen la ADDRESS 0x3C y se usa un CI CD4066B como demultiplexer
 * para tomar las señales SDA y SCL del Nano y dirigirlas por separado a los OLED
 * comandados por una señal que sale del Pin D4 del Nano hacia los pines de control
 * del CD4066, de la siguiente forma:
 * 
 * Pin A4 del Nano SDA a los pines 1 y 4 del CD4066B
 * Pin A5 del Nano SCL a los pines 8 y 11 del CD4066B
 * Pin D4 del Nano a los pines 6 y 13 del CD4066B
 * Pin D5 del Nano a los pines 5 y 12 del CD4066B
 * Pin 2 del CD4066B al Pin SDA del OLED 1
 * Pin 9 del CD4066B al Pin SCL del OLED 1
 * Pin 3 del CD4066B al Pin SDA del OLED 2
 * Pin 10 del CD4066B al Pin SCL del OLED 2
 * 
 * El Pin D4 del Nano se va a HIGH para activar el OLED 2 
 * El Pin D5 del Nano se va a HIGH para activar el OLED 1
 * 
 * Los pines D4 y D5 solo están al mismo nivel (HIGH) en el setup() para reconocer
 * a ambos displays. En el loop() alternan entre LOW y HIGH.
 * 
 * Durante la programación del codigo, se dirigiran los datos de I2C al OLED 1 u OLED 2
 * dependiendo de los niveles del Pin D4 y del Pin D5
 * 
 * Alfredo Segura, Queretaro Mexico, octubre de 2025
 * 
*/

#include <stdio.h> 
#include <Wire.h>
#include <Adafruit_GFX.h>
#include <Adafruit_SSD1306.h>
 
// A4 del Nano es SDA del OLED
// A5 del Nano es SCL del OLED


double frec1 = 26.965;
double frec2 = 27.025;
int canal1 = 1;
int canal2 = 7;
int ancho = 128;               // ancho pantalla en puntos
int alto = 64;                 // alto pantalla en puntos
byte pinD4 = 4;                // Pin D4 del Nano para controlar el CD4066B
byte pinD5 = 5;                // Pin D5 del Nano para controlar el CD4066B
bool flag1 = false;
bool flag2 = true;

Adafruit_SSD1306 oled0x3c(ancho, alto, &Wire, -1);

void setup() {
  Serial.begin(9600);
  pinMode(pinD4, OUTPUT);
  pinMode(pinD5, OUTPUT);
  digitalWrite(pinD4, HIGH);
  digitalWrite(pinD5, HIGH);
  
  Wire.begin();
  
  if (!oled0x3c.begin(SSD1306_SWITCHCAPVCC, 0x3C)) {     // 0x3C
    Serial.println("No esta respondiendo el OLED 0x3C...");
    for(;;);
  }
  Serial.println("Respondiendo correctamente el OLED 0x3C...");
  digitalWrite(pinD4, HIGH);
  digitalWrite(pinD5, LOW);  
}
  
void loop() {
  if (digitalRead(pinD4) == HIGH) {
    digitalWrite(pinD5, LOW);
    oled0x3c.clearDisplay();               // Limpiamos pantalla  oled0x3c
    oled0x3c.setTextSize(3);               // Tamaño del texto  
    oled0x3c.setTextColor(SSD1306_WHITE);  // Color WHITE para que se vea el texto
    oled0x3c.setCursor(0, 1);              // Posición del texto en puntos (renglon, columna)
    oled0x3c.println(frec1, 3);            // Imprimimos los datos
    oled0x3c.setCursor(4, 40);
    oled0x3c.print("CH: ");
    oled0x3c.println(canal1);
    oled0x3c.display();                    // Mostrar todo en el display
    frec1 += 0.01;
    digitalWrite(pinD4, LOW);
  }
  
  if (digitalRead(pinD4) == LOW) {
    digitalWrite(pinD5, HIGH);
    oled0x3c.clearDisplay();               // Limpiamos pantalla  oled0x3c
    oled0x3c.setTextSize(3);               // Tamaño del texto  
    oled0x3c.setTextColor(SSD1306_WHITE);  // Color WHITE para que se vea el texto
    oled0x3c.setCursor(0, 1);              // Posición del texto en puntos (renglon, columna)
    oled0x3c.println(frec2, 3);            // Imprimimos los datos
    oled0x3c.setCursor(4, 40);
    oled0x3c.print("CH: ");
    oled0x3c.println(canal2);
    oled0x3c.display();                    // Mostrar todo en el display
    frec2 += 0.01;
    digitalWrite(pinD4, HIGH);    
  }

  delay(1000);
}
