/* ___SETA43  _____
  seta43.duckdns.org
  seta43.blogspot.com
___ 22/10/2025 _____
SERVER _OLED
*/
// Comprobar el fabricante de ESP32C3MINI para los pins
//En mi caso ESP32-C3 MINI  (compilar como LOLIN C3 MINI)
//https://www.espboards.dev/esp32/lolin-c3-mini/#tech-specs
// SDA->8   SCL 10 
// LED  ping-> 0,1,3,4
/////////////////////////////////////////////////////////////////

char nombre[]="ESP32-C3 SERVER";
char VARI[20];

//___________OLED_________
#include "olex.h"
#include <Wire.h>

#include <WiFi.h>

const char * ssid = "ESP32_C3_AP";
const char * password = "123456789";

WiFiServer server(80);

String header;

String output4State = "off";
String output3State = "off";
String output0State = "off";
String output1State = "off";

#define LEDd 4
#define LEDc 3
#define LEDb 1
#define LEDa 0

void setup()
{
	Serial.begin(115200);

	pinMode(LEDd, OUTPUT);
	pinMode(LEDc, OUTPUT);
	pinMode(LEDa, OUTPUT);
	pinMode(LEDb, OUTPUT);
	
	digitalWrite(LEDd, LOW);
	digitalWrite(LEDc, LOW);
	digitalWrite(LEDa, LOW);
	digitalWrite(LEDb, LOW);
	
  delay(1000);
  Serial.println(nombre);  
   
	Serial.print("Setting AP (Access Point)…");
	WiFi.softAP(ssid, password);
	IPAddress IP = WiFi.softAPIP();
	Serial.print("AP IP address: ");
	Serial.println(IP);
	server.begin();

  Wire.begin(); // I2C bus
  OleInit();  delay(500); 
  xclearDisplay(); 
  ModeFont=0; 
  xStringAT(1,0,(char *)nombre);
  xStringAT(2,2,(char *)ssid); 
  xStringAT(2,4,(char *)password);  sprintf(VARI, "%d.%d.%d.%d",IP[0], IP[1], IP[2], IP[3]);
  xStringAT(1,6,VARI);

}

void loop()
{
	WiFiClient client = server.available(); 
	
	if(client)
	{ 
		Serial.println("New Client."); 
		String currentLine = ""; 
		while(client.connected())
		{ 
			if(client.available())
			{ 
				char c = client.read(); 
				Serial.write(c); 
				header += c;
				if(c == '\n')
				{ 
					if(currentLine.length() == 0)
					{
						client.println("HTTP/1.1 200 OK");
						client.println("Content-type:text/html");
						client.println("Connection: close");
						client.println();
						
						if(header.indexOf("GET /4/on") >= 0)
						{
							Serial.println("GPIO 4 on");
							output4State = "on";
							digitalWrite(LEDd, HIGH);
						}
						else if(header.indexOf("GET /4/off") >= 0)
						{
							Serial.println("GPIO 4 off");
							output4State = "off";
							digitalWrite(LEDd, LOW);
						}
						else if(header.indexOf("GET /3/on") >= 0)
						{
							Serial.println("GPIO 3 on");
							output3State = "on";
							digitalWrite(LEDc, HIGH);
						}
						else if(header.indexOf("GET /3/off") >= 0)
						{
							Serial.println("GPIO 3 off");
							output3State = "off";
							digitalWrite(LEDc, LOW);
						}					
												
						else if(header.indexOf("GET /1/on") >= 0)
						{
							Serial.println("GPIO 1 on");
							output1State = "on";
							digitalWrite(LEDb, HIGH);
						}
						else if(header.indexOf("GET /1/off") >= 0)
						{
							Serial.println("GPIO 1 off");
							output1State = "off";
							digitalWrite(LEDb, LOW);
						}

           else if(header.indexOf("GET /0/on") >= 0)
           {
              Serial.println("GPIO 0 on");
              output0State = "on";
              digitalWrite(LEDa, HIGH);
            }
            else if(header.indexOf("GET /0/off") >= 0)
            {
              Serial.println("GPIO 0 off");
              output0State = "off";
              digitalWrite(LEDa, LOW);
            }
						
						client.println("<!DOCTYPE html><html>");
						client.println("<head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">");
						client.println("<link rel=\"icon\" href=\"data:,\">");

						client.println("<style>html { font-family: Helvetica; display: inline-block; margin: 0px auto; text-align: center;}");
						client.println(".button { background-color: #4CAF50; border: none; color: white; padding: 12px 30px;");
						client.println("text-decoration: none; font-size: 30px; margin: 2px; cursor: pointer;}");
						client.println(".button2 {background-color: #555555;}</style></head>");
						
						client.println("<body><h1>ESP32-C3 Server</h1>");
						
						client.println("<p>GPIO 4 - ESTADO " + output4State + "</p>");
						if(output4State == "off") { client.println("<p><a href=\"/4/on\"><button class=\"button\">ON</button></a></p>"); }
						else { client.println("<p><a href=\"/4/off\"><button class=\"button button2\">OFF</button></a></p>"); }
						
						client.println("<p>GPIO 3 - ESTADO " + output3State + "</p>");
						if(output3State == "off") { client.println("<p><a href=\"/3/on\"><button class=\"button\">ON</button></a></p>"); }
						else { client.println("<p><a href=\"/3/off\"><button class=\"button button2\">OFF</button></a></p>"); }
												
						client.println("<p>GPIO 1 - ESTADO " + output1State + "</p>");
						if(output1State == "off") { client.println("<p><a href=\"/1/on\"><button class=\"button\">ON</button></a></p>"); }
						else { client.println("<p><a href=\"/1/off\"><button class=\"button button2\">OFF</button></a></p>"); }

            client.println("<p>GPIO 0 - ESTADO " + output0State + "</p>");
            if(output0State == "off") { client.println("<p><a href=\"/0/on\"><button class=\"button\">ON</button></a></p>"); }
            else { client.println("<p><a href=\"/0/off\"><button class=\"button button2\">OFF</button></a></p>"); }
            						
						client.println("</body></html>");						
						client.println();
						break;
					}
					else 
					{ currentLine = ""; }
					
				}
				else
				if(c != '\r') { currentLine += c; }
				
			}
		}

		header = "";
		client.stop();
		Serial.println("Client disconnected.");
		Serial.println("");
	}
}
