/*
___SETA43  _____
  seta43.duckdns.org
  seta43.blogspot.com
___ 25/10/2025 _____
*/

char nombre[]="ESP32-C3 Router";
char VARI[20];

//___________OLED_________
#include "olex.h"
#include <Wire.h>

#include <WiFi.h>
#include <WebServer.h>

// Replace with your network credentials
const char* ssid = "Mi_WIFI";
const char* password = "password";


#define LEDd 4
#define LEDc 3
#define LEDb 1
#define LEDa 0

String output4State = "off";
String output3State = "off";
String output1State = "off";
String output0State = "off";


WebServer server(80);


void funcionPin0_on() 
  {  output0State = "on";  digitalWrite(LEDa, HIGH);  handleRoot();}

void funcionPin0_off() 
  {  output0State = "off";  digitalWrite(LEDa, LOW);  handleRoot();}

void funcionPin1_on() 
  {  output1State = "on";  digitalWrite(LEDb, HIGH);  handleRoot();}

void funcionPin1_off() 
  {  output1State = "off";  digitalWrite(LEDb, LOW);  handleRoot();}

void funcionPin3_on() 
  {  output3State = "on";  digitalWrite(LEDc, HIGH);  handleRoot();  }

void funcionPin3_off() 
  {  output3State = "off";  digitalWrite(LEDc, LOW);  handleRoot(); }

void funcionPin4_on() 
  {  output4State = "on";  digitalWrite(LEDd, HIGH);  handleRoot();  }

void funcionPin4_off() 
  {  output4State = "off";  digitalWrite(LEDd, LOW);  handleRoot(); }



void handleRoot() 
{
  String html ="<!DOCTYPE html><html>";
  html +="<head><meta name=\"viewport\" content=\"width=device-width, initial-scale=1\">";
  html +="<link rel=\"icon\" href=\"data:,\">";

  if(output4State == "on")
    {
      html +="<style>html { font-family: Helvetica; display: inline-block; margin: 0px auto; text-align: center;}";
      html +=".button { background-color: #4CAF50; border: none; color: white; padding: 12px 20px;";
      html +="text-decoration: none; font-size: 20px; margin: 1px; cursor: pointer;}";
      html +=".button2 {background-color: #555555;}</style></head>";
    }
  
  html +="<body><h3>ESP32-C3 Server-Route SETA43</h3>";

  html +="<p>GPIO 0 - ESTADO " + output0State + "</p>";
  if(output0State == "off") { html +="<p><a href=\"/0/on\"><button class=\"button\">ON</button></a></p>"; }
  else { html +="<p><a href=\"/0/off\"><button class=\"button button2\">OFF</button></a></p>"; }

  html +="<p>GPIO 1 - ESTADO " + output1State + "</p>";
  if(output1State == "off") { html +="<p><a href=\"/1/on\"><button class=\"button\">ON</button></a></p>"; }
  else { html +="<p><a href=\"/1/off\"><button class=\"button button2\">OFF</button></a></p>"; }
 
  html +="<p>GPIO 3 - ESTADO " + output3State + "</p>";
  if(output3State == "off") { html +="<p><a href=\"/3/on\"><button class=\"button\">ON</button></a></p>"; }
  else { html +="<p><a href=\"/3/off\"><button class=\"button button2\">OFF</button></a></p>"; }
        
  html +="<p>GPIO 4 - ESTADO " + output4State + "</p>";
  if(output4State == "off") { html +="<p><a href=\"/4/on\"><button class=\"button\">ON</button></a></p>"; }
  else { html +="<p><a href=\"/4/off\"><button class=\"button button2\">OFF</button></a></p>"; }


  html += "</body></html>";
  server.send(200, "text/html", html);
  Serial.print("PIN0="); Serial.print(output0State);
  Serial.print("  PIN1="); Serial.print(output1State);
  Serial.print("  PIN3="); Serial.print(output3State);
  Serial.print("  PIN4="); Serial.println(output4State);
  
}




void setup() 
{
  Serial.begin(9600);

  pinMode(LEDd, OUTPUT);
  pinMode(LEDc, OUTPUT);
  pinMode(LEDa, OUTPUT);
  pinMode(LEDb, OUTPUT);
  
  digitalWrite(LEDd, LOW);
  digitalWrite(LEDc, LOW);
  digitalWrite(LEDa, LOW);
  digitalWrite(LEDb, LOW);

  Wire.begin(); // I2C bus
  OleInit();
  
  delay(1000);
  
  xclearDisplay();
  xStringAT(1,0,(char *)"Connecting...");
  Serial.println(nombre);  

  // Connect to Wi-Fi network
  Serial.print("Connecting to ");
  Serial.println(ssid);
  WiFi.begin(ssid, password);
  int z=0;
  while (WiFi.status() != WL_CONNECTED) 
  {
    delay(500);
    Serial.print(".");
    xCaracterAT(z,5,'.');
    if(z<10)z++;
  }
  Serial.println("");
  Serial.println("WiFi connected.");
  IPAddress IP=WiFi.localIP();

  Serial.print("NAME: "); Serial.println(ssid);
  Serial.print("password: "); Serial.println(password);
  Serial.print("IP address: ");  Serial.println(IP);


  server.on("/", handleRoot);
  server.on("/0/on", funcionPin0_on);
  server.on("/0/off", funcionPin0_off);
  server.on("/1/on", funcionPin1_on);
  server.on("/1/off", funcionPin1_off);
  server.on("/3/on", funcionPin3_on);
  server.on("/3/off", funcionPin3_off);
  server.on("/4/on", funcionPin4_on);
  server.on("/4/off", funcionPin4_off);

  server.begin();
  Serial.println("HTTP server started");

  xclearDisplay();
  ModeFont=0; 
  xStringAT(1,0,(char *)nombre);
  xStringAT(2,2,(char *)ssid); 
  xStringAT(2,4,(char *)password);  
  sprintf(VARI, "%d.%d.%d.%d",IP[0], IP[1], IP[2], IP[3]);
  xStringAT(1,6,VARI);

}

void loop() 
{
  server.handleClient();
}
