// xsetaseta@gmail.com
// 13/09/2025
// SERVO CAPACITOR

#include "BluetoothSerial.h"

#if !defined(CONFIG_BT_ENABLED) || !defined(CONFIG_BLUEDROID_ENABLED)
#error Bluetooth is not enabled! Please run `make menuconfig` to and enable it
#endif

BluetoothSerial SerialBT;


char nombre[]="\nSERVO_Condensador";

#define SERVO_PIN1 2
#define SERVO_PIN2 4
#define LEDC_RESOLUTION 10 // Set resolution to 10 bits

char entrada[100];
int contador=0;
boolean stringComplete = false;
char inChar;

int posicion=36,posicion2=22;

char VARI[40];

void setup() 
{
  Serial.begin(9600);
  SerialBT.begin("ESP32_SERVO"); //Bluetooth 
  delay(300);
  Serial.println(nombre);
  ledcAttach(SERVO_PIN1, 50, LEDC_RESOLUTION);
  ledcAttach(SERVO_PIN2, 50, LEDC_RESOLUTION);

  Serial.println("Esperando datos [0-108] C1->x C2->y   x10 o y20");
  Serial.println("Teclas C1[+ -]  C2[q a]");
  SerialBT.println("Esperando datos [0-108]");
  SerialBT.println("Teclas C1[+ -]  C2[q a]");

  servo1Data(posicion);
  servo2Data(posicion2);
}


void loop()
{

  while (Serial.available() || SerialBT.available())
    {
    if(Serial.available())    inChar = (char)Serial.read(); 
    if(SerialBT.available())  inChar = (char)SerialBT.read(); 
    entrada[contador]=inChar; 
    if (inChar == '\n')
        {
          stringComplete = true;
          entrada[contador]=0;
        } 
    if(contador<40)contador++;  
    } 
    
  if (stringComplete) 
    { 
      Serial.println(entrada);
      
      switch(entrada[0])
      {
        case 'o':
         ledcAttach(SERVO_PIN1, 50, LEDC_RESOLUTION); 
         ledcAttach(SERVO_PIN2, 50, LEDC_RESOLUTION);
         Serial.println("OPEN"); SerialBT.println("OPEN");
         servo1Data(posicion);
         servo2Data(posicion2);
        break;
        case 'c':
         ledcDetach(SERVO_PIN1);
         ledcDetach(SERVO_PIN2);
         Serial.println("CLOSE"); SerialBT.println("CLOSE");
        break;
        case 'a':
         posicion2--; if(posicion2<0)posicion2=0; servo2Data(posicion2);
        break;
        case 'q':
         posicion2++; if(posicion2>108)posicion2=108;  servo2Data(posicion2);
        break;
        case '-':
         posicion--; if(posicion<0)posicion=0;  servo1Data(posicion);
        break;
        case '+':
         posicion++; if(posicion>108)posicion=108; servo1Data(posicion);
        break;
        case 'x':
         entrada[0]=32; 
         posicion=atoi(entrada);  
         if(posicion<0)posicion=0;
         if(posicion>108)posicion=108; 
         servo1Data(posicion);  
        break;
        case 'y':
         entrada[0]=32; 
         posicion2=atoi(entrada);  
         if(posicion2<0)posicion2=0;
         if(posicion2>108)posicion2=108; 
         servo2Data(posicion2);
        break;
        default:
          Serial.print("ERROR->"); Serial.print(entrada); Serial.println("<");
          SerialBT.print("**");SerialBT.print("ERROR->"); SerialBT.print(entrada); SerialBT.println("<");
        break;
      }

      contador=0;
      stringComplete = false;
    }

}

void printDatos(void)
{
  sprintf(VARI,"C1=%03d C2=%03d ",posicion,posicion2);
  SerialBT.print("*");SerialBT.println(VARI); 
  Serial.println(VARI);
}



void servo1Data(int Data)
{
  printDatos();
  ledcWrite(SERVO_PIN1, Data+22);
}


void servo2Data(int Data)
{
  printDatos();
  ledcWrite(SERVO_PIN2, Data+22);
}
